/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.impl;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.capability.ToolInventoryCapability;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public class InventoryModifier
extends Modifier
implements ToolInventoryCapability.InventoryModifierHook {
    protected static final BiFunction<class_2487, String, class_2499> GET_COMPOUND_LIST = (nbt, name) -> nbt.method_10554(name, 10);
    private static final ValidatedResult HAS_ITEMS = ValidatedResult.failure(TConstruct.makeTranslationKey("modifier", "inventory_cannot_remove"), new Object[0]);
    protected static final String TAG_SLOT = "Slot";
    @Nullable
    private final class_2960 inventoryKey;
    protected final int slotsPerLevel;
    private final List<class_2487> snapshots = new ArrayList<class_2487>();

    public InventoryModifier(int slotsPerLevel) {
        this(null, slotsPerLevel);
    }

    protected class_2960 getInventoryKey() {
        return this.inventoryKey == null ? this.getId() : this.inventoryKey;
    }

    @Override
    public void addVolatileData(ToolRebuildContext context, int level, ModDataNBT volatileData) {
        ToolInventoryCapability.addSlots(volatileData, this.getSlots(context, level));
    }

    protected ValidatedResult validateForMaxSlots(IToolStackView tool, int maxSlots) {
        class_2499 listNBT;
        class_2960 key;
        ModDataNBT persistentData = tool.getPersistentData();
        if (persistentData.contains(key = this.getInventoryKey(), 9) && !(listNBT = persistentData.get(key, GET_COMPOUND_LIST)).isEmpty()) {
            int i;
            if (maxSlots == 0) {
                return HAS_ITEMS;
            }
            BitSet freeSlots = new BitSet(maxSlots);
            freeSlots.set(0, maxSlots - 1, true);
            for (i = 0; i < listNBT.size(); ++i) {
                freeSlots.set(listNBT.method_10602(i).method_10550(TAG_SLOT), false);
            }
            for (i = 0; i < listNBT.size(); ++i) {
                class_2487 compoundNBT = listNBT.method_10602(i);
                if (compoundNBT.method_10550(TAG_SLOT) < maxSlots) continue;
                int free = freeSlots.stream().findFirst().orElse(-1);
                if (free == -1) {
                    return HAS_ITEMS;
                }
                freeSlots.set(free, false);
                compoundNBT.method_10569(TAG_SLOT, free);
            }
        }
        return ValidatedResult.PASS;
    }

    @Override
    public ValidatedResult validate(IToolStackView tool, int level) {
        return this.validateForMaxSlots(tool, level == 0 ? 0 : this.getSlots((IToolContext)tool, level));
    }

    @Override
    public void onRemoved(IToolStackView tool) {
        tool.getPersistentData().remove(this.getInventoryKey());
    }

    @Override
    public class_1799 getStack(IToolStackView tool, ModifierEntry modifier, int slot) {
        ModDataNBT modData = tool.getPersistentData();
        class_2960 key = this.getInventoryKey();
        if (slot < this.getSlots(tool, modifier) && modData.contains(key, 9)) {
            class_2499 list = tool.getPersistentData().get(key, GET_COMPOUND_LIST);
            for (int i = 0; i < list.size(); ++i) {
                class_2487 compound = list.method_10602(i);
                if (compound.method_10550(TAG_SLOT) != slot) continue;
                return class_1799.method_7915((class_2487)compound);
            }
        }
        return class_1799.field_8037;
    }

    @Override
    public void setStack(IToolStackView tool, ModifierEntry modifier, int slot, class_1799 stack) {
        if (slot < this.getSlots(tool, modifier)) {
            class_2499 list;
            class_2960 key;
            ModDataNBT modData = tool.getPersistentData();
            if (modData.contains(key = this.getInventoryKey(), 9)) {
                list = modData.get(key, GET_COMPOUND_LIST);
                for (int i = 0; i < list.size(); ++i) {
                    class_2487 compound = list.method_10602(i);
                    if (compound.method_10550(TAG_SLOT) != slot) continue;
                    if (stack.method_7960()) {
                        list.method_10536(i);
                    } else {
                        compound.method_10541().clear();
                        stack.method_7953(compound);
                        compound.method_10569(TAG_SLOT, slot);
                    }
                    return;
                }
            } else {
                if (stack.method_7960()) {
                    return;
                }
                list = new class_2499();
                modData.put(key, (class_2520)list);
            }
            if (!stack.method_7960()) {
                list.add((Object)InventoryModifier.write(stack, slot));
            }
        }
    }

    @Override
    public void updateSnapshots(IToolStackView tool, ModifierEntry modifier, int slot, TransactionContext transaction) {
        while (this.snapshots.size() <= transaction.nestingDepth()) {
            this.snapshots.add(null);
        }
        if (this.snapshots.get(transaction.nestingDepth()) == null) {
            class_2487 snapshot = new class_2487();
            tool.getPersistentData().writeToNbt(snapshot);
            Objects.requireNonNull(snapshot, "Snapshot may not be null!");
            this.snapshots.set(transaction.nestingDepth(), snapshot);
            transaction.addCloseCallback((TransactionContext.CloseCallback)new OnClose(tool));
        }
    }

    public int getSlots(IToolContext tool, int level) {
        return level * this.slotsPerLevel;
    }

    @Override
    public final int getSlots(IToolStackView tool, ModifierEntry modifier) {
        return this.getSlots((IToolContext)tool, modifier.getLevel());
    }

    @Override
    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook(this, ToolInventoryCapability.HOOK);
    }

    protected static class_2487 write(class_1799 stack, int slot) {
        class_2487 compound = new class_2487();
        stack.method_7953(compound);
        compound.method_10569(TAG_SLOT, slot);
        return compound;
    }

    public InventoryModifier(@Nullable class_2960 inventoryKey, int slotsPerLevel) {
        this.inventoryKey = inventoryKey;
        this.slotsPerLevel = slotsPerLevel;
    }

    public class OnClose
    implements TransactionContext.CloseCallback {
        private final IToolStackView tool;

        public void onClose(TransactionContext t, TransactionContext.Result result) {
            class_2487 lastSnapshot = InventoryModifier.this.snapshots.set(t.nestingDepth(), null);
            if (result.wasAborted()) {
                this.tool.setPersistentData(ModDataNBT.readFromNBT(lastSnapshot));
            } else if (t.nestingDepth() > 0 && InventoryModifier.this.snapshots.get(t.nestingDepth() - 1) == null) {
                InventoryModifier.this.snapshots.set(t.nestingDepth() - 1, lastSnapshot);
                t.getOpenTransaction(t.nestingDepth() - 1).addCloseCallback((TransactionContext.CloseCallback)this);
            }
        }

        public OnClose(IToolStackView tool) {
            this.tool = tool;
        }
    }
}

